﻿Imports System.Windows.Data

Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private ReadOnly okBrush As Brush
    Private Shared ReadOnly errorBrush As Brush = New SolidColorBrush(Colors.Red)

    Public Sub New()
        InitializeComponent()
        okBrush = New TextBox().Foreground
    End Sub

    Private Sub OnTextBoxTextChanged(ByVal sender As Object, ByVal args As TextChangedEventArgs)
        Dim txtbox = TryCast(sender, TextBox)
        txtbox.Foreground = okBrush

        Dim bindingExpression = txtbox.GetBindingExpression(TextBox.TextProperty)
        bindingExpression.UpdateSource()
    End Sub

    Private Sub OnBindingValidationError(ByVal sender As Object, ByVal args As ValidationErrorEventArgs) Handles Me.BindingValidationError
        Dim txtbox = TryCast(args.OriginalSource, TextBox)
        txtbox.Foreground = errorBrush
    End Sub
End Class

